/** Javascript for Notepad Widget 
	(c) 2005 Stewart Hector
**/

//Constants for preference keys
var KEY_MAX_ENTRIES = "MAX_ENTRY";
var KEY_CATEGORY_NAME = "CATEGORY_NAME";
var KEY_NOTEPAD_ENTRY = "NOTEPAD_ENTRY_";
var KEY_AUTOSAVE = "AUTOSAVE_";
var KEY_TEXT_COLOUR ="TEXT_COLOR";
var KEY_USER_DEFINED_TEXT_COLOUR = "USERDEFINED_TEXT_COLOUR";
var KEY_USER_DEFINED_BACKGROUND_COLOUR = "USERDEFINED_BACKGROUND_COLOUR";
var KEY_BACKGROUND_COLOUR  = "BG_COLOUR";
var KEY_FONT_TYPE = "FONT_TYPE";
var KEY_FONT_SIZE = "FONT_SIZE";
var KEY_BACKGROUND_IMAGE ="BG_IMAGE";

var KEY_NEW_ENTRY ="_newentry";

var	KB_DELETE = 8;
var KB_TAB = 9;

//Constants for config, default values
var DEFAULT_MAX_ENTRIES = 50;
var DEFAULT_CATEGORY_NAME = "Give me a Category";
var DEFAULT_NOTEPAD_ENTRY = "";
var DEFAULT_AUTOSAVE 	  = false;
var DEFAULT_BACKGROUND_COLOUR  = 'yellowBackground';
var DEFAULT_TEXT_COLOR = "blackText"
var DEFAULT_TEXT_COLOUR_INDEX = 3;
var DEFAULT_FONT_TYPE = "Chalk Board";
var DEFAULT_FONT_SIZE = 9;
var DEFAULT_BACKGROUND_IMAGE = "Default.png";

//Constant colours
var COLOUR_BLACK = "#000000";
var COLOUR_STANDARD_YELLOW = "#faffa9";
var COLOUR_LIGHT_GREY = "#eeeeee";
var COLOUR_DARK_GREY = "#464646";

var NOT_FOUND = -1;

var colour = new Array ( 7 ) ;
colour[0] = "blue";
colour[1] = "red";
colour[2] = "black";
colour[3] = "white";
colour[4] = "green";
colour[5] = "yellow";
colour[6] = "userdefined";

var colourCode = new Array ( 7 );
colourCode[0] ="#6666ff";
colourCode[1] ="#ff0033";
colourCode[2] ="#000000";
colourCode[3] ="#ffffff";
colourCode[4] ="#33ff66";
colourCode[5] ="#faffa9";
colourCode[6] ="userDefined";

var backgroundImage = new Array (2);
backgroundImage[0] = DEFAULT_BACKGROUND_IMAGE;
backgroundImage[1] = "Notepad-bg.png";


var maxEntries;
var categoryName;
var autoSave;
var textColour;
var userDefinedTextColour;
var backgroundColour;
var userDefinedBackgroundColour;
var fontSize;
var fontType;
var backgroundImage;

var entries = new Array ( );

var DEBUG = true;
var DEBUG_TEST = false;


function log ( message )
{
	if ( DEBUG )
	{
		alert ( message);
	}
}

/** Get preferences.  

	returns - if false is returned, the widget has no preferences 
**/
function loadPreferences ( ) 
{	
	if (window.widget)
	{
		log ("Getting preferences..");
		maxEntries = getPreferenceValue ( KEY_MAX_ENTRIES, DEFAULT_MAX_ENTRIES );
		categoryName = getPreferenceValue ( KEY_CATEGORY_NAME, DEFAULT_CATEGORY_NAME );
		autoSave = getPreferenceValue ( KEY_AUTOSAVE, DEFAULT_AUTOSAVE );  
		backgroundColour  = getPreferenceValue ( KEY_BACKGROUND_COLOUR, DEFAULT_BACKGROUND_COLOUR );  
		userDefinedBackgroundColour = getPreferenceValue ( KEY_USER_DEFINED_BACKGROUND_COLOUR, null);  
		
		
		textColour  = getPreferenceValue ( KEY_TEXT_COLOUR, DEFAULT_TEXT_COLOR);
		
		log ( "********************************************* " + textColour);
		
		userDefinedTextColour  = getPreferenceValue ( KEY_USER_DEFINED_TEXT_COLOUR, null);  		 
		fontType = getPreferenceValue ( KEY_FONT_TYPE, DEFAULT_FONT_TYPE);
		fontSize = getPreferenceValue ( KEY_FONT_SIZE, DEFAULT_FONT_SIZE);
		
		backgroundImage = getPreferenceValue ( KEY_BACKGROUND_IMAGE, DEFAULT_BACKGROUND_IMAGE);
		
		
		log ("Font Type = " + fontType);
		log ("font Size = " + fontSize);
		log ("text colour = " + textColour);
		log ("bg colour = " + backgroundColour);
		log ("user defined text colour = " + userDefinedTextColour);
		log ("user defined bg colour = " + userDefinedBackgroundColour );
		log ("BackgroundImage = " + backgroundImage);
		
		
	}
	log ("Done getting prefs");
}


function savePreferences ( ) 
{
	log ("maxEntries = " + maxEntries + ", key = " + createkey( KEY_MAX_ENTRIES ));
	widget.setPreferenceForKey( maxEntries, createkey( KEY_MAX_ENTRIES ))

	log ("category  = " + categoryName + ", key = " + createkey( KEY_CATEGORY_NAME ));
	widget.setPreferenceForKey( categoryName, createkey( KEY_CATEGORY_NAME ))
	
	log ("autosave  = " + autoSave + ", key = " + createkey( KEY_AUTOSAVE ));
	widget.setPreferenceForKey( autoSave, createkey( KEY_AUTOSAVE ))

	log ("saving, BG Colour  = " + backgroundColour + ", key = " + createkey( KEY_BACKGROUND_COLOUR ));
	widget.setPreferenceForKey( backgroundColour, createkey( KEY_BACKGROUND_COLOUR ));

	log("userDefinedBackgroundColour = " + userDefinedBackgroundColour);

//	log ("Saving, UserDefined background colour " + userDefinedBackgroundColour + ", key = " + createKey (KEY_USER_DEFINED_BACKGROUND_COLOUR ));
	widget.setPreferenceForKey( userDefinedBackgroundColour, createkey( KEY_USER_DEFINED_BACKGROUND_COLOUR ));

//	log ("saving, text Colour  = " + textColour + ", key = " + createkey( KEY_TEXT_COLOUR ));
	widget.setPreferenceForKey( textColour, createkey( KEY_TEXT_COLOUR ))


	widget.setPreferenceForKey( userDefinedTextColour, createkey( KEY_USER_DEFINED_TEXT_COLOUR ));
	
	log ("saving, font type = " + fontType + ", key = " + createkey( KEY_FONT_TYPE));
	widget.setPreferenceForKey( fontType, createkey( KEY_FONT_TYPE ))

	log ("saving, font size  = " + fontSize + ", key = " + createkey( KEY_FONT_SIZE ));
	widget.setPreferenceForKey( fontSize, createkey( KEY_FONT_SIZE ))

	log ("saving, background Image = " + backgroundImage + ", key = " + createkey( KEY_BACKGROUND_IMAGE ));
	widget.setPreferenceForKey( backgroundImage, createkey( KEY_BACKGROUND_IMAGE ));

	log("Save preferences done");

}


/** Returns a value from preferences 

	params - 
		key 			Key to look up
		defaultValue	If key is null then reutrn this value
		generated		should createKey method be applied to this key
**/
function getPreferenceValue ( key, defaultValue , generated)
{
	if ( !generated ) 
	{
		log ("Creating Key for incoming key");
		key = createkey( key ) ;
	}

	log("getting key " + key  );

	value = widget.preferenceForKey( key );
		
		
	if (!value)
	{
		value = defaultValue;
	}

	log ("Value for key = "  + value);

	return value;
}
/** Saves a single entry to prefs file.  If there is an oldkey, the pref entry related to this will be removed.

	params:
		
		new key - new key to save with
		old key - the entry's old key
		entry   - text
**/		
function saveNoteEntry ( newKey, oldKey, entry)
{
	log ("Saving Entry.....");
	//remove old key
	
//	oldKey = createkey( KEY_NOTEPAD_ENTRY,oldKey );
//	newKey = createkey( KEY_NOTEPAD_ENTRY,newKey );
	
	log ( "oldkey = " + oldKey + ", new entry default key  = " + KEY_NEW_ENTRY);
	
	if ( oldKey != KEY_NEW_ENTRY )
	{
		log("removing old = "  + oldKey);
		widget.setPreferenceForKey( null, oldKey)
	}
	
	log("saving new = "  + newKey + ", value = " + entry);	
	widget.setPreferenceForKey( entry, newKey )
	
	log ("done");
}

/**  Load a single entry

	 params:
		Subkey is an index
**/
function loadEntry  (  subkey )
{
	value = null;
	
	if ( subkey != KEY_NEW_ENTRY )
	{
		log("load with key = " + subkey );
		value = widget.preferenceForKey( subkey  ); 	
		
		value = getPreferenceValue ( subkey, DEFAULT_NOTEPAD_ENTRY, true );
	}
	
	getNotePad().value = value;
	
}

function removeComboItem ( combo, index )
{

}

function deletePreferenceItem ( key ) 
{
	widget.setPreferenceForKey( null, key);
	
}

/** Loads a entry into the widget upon the Entry combo box being changed to a new selection
**/
function onChangeEntriesCombo ( combo )
{	
	clearStatusBar();
	key = getSelectedOption ( combo ).value;
	loadEntry ( key );
}

/** Highlight the selected block with a border, and remove the border from others
    i.e., the behaviour you'd find in a radio box group, only one item can have focus in the group of 'things'
    
    params:
    
    GroupName -	Group ( text) of colours
    selectedColourid		- id text of selected colour block
**/
function onClickColourBlock ( groupName, selectedColourId ,  userDefinedId, userDefinedTextId)
{
	log ( "groupName = " + groupName  +", id = " + selectedColourId  + ", userdefinedId = " + userDefinedId +", user defined text id " + userDefinedTextId);
	
	userDefinedId = document.getElementById ( userDefinedId );
	
	group = document.getElementsByName ( groupName );
	
	log ("Items in group =  " + group.length );
	
	var colourIndex;
	
	for ( i = 0 ; i < group.length ; i++)
	{
		item = group.item ( i );
		log ( " Item = " + i + " : " + item.id );

		item.style.border = "1px solid " + COLOUR_DARK_GREY;
		item.checked = false;

		if ( item.id == selectedColourId.id ) 
		{
			log ("Colour index is = " + i );
			colourIndex = i;
			item.checked = true;
		}
		
	}
	
	log ( " selected  = " + selectedColourId.id);
	selectedColourId.style.border = "1px solid " + COLOUR_LIGHT_GREY;

	userTextEdit = document.getElementById ( userDefinedTextId );

	log ("User defined text edit = " + userTextEdit.id);
		
	log ( "text = " + userText );

	log ( userDefinedId);

	if ( selectedColourId.id == userDefinedTextId || selectedColourId.id == userDefinedId.id )
	{
		log ("selecting config text");
		userDefinedId.style.border = "1px solid " + COLOUR_LIGHT_GREY;
		userTextEdit.focus();
		userDefinedId.checked = true;
	}
	else
	{
		log ("bluring");
		userTextEdit.blur();
		userTextEdit.value = "";
	}
	
	log ("onClickColourBlock is done");
}

function onUserDefinedColourKeyPress( event )
{
	result = true;
	
	key = event.keyCode;
	
	if (! ( key == KB_TAB || key == KB_DELETE ))
	{
		ch = String.fromCharCode(key);
		
		isValidNumber = ( ch >= "0" && ch <="9" ) ;
		
		ch = ch.toUpperCase();
		
		isValidChar = ( ch >= "A" && ch <="F" );
		
		result = isValidNumber || isValidChar;
		
		log ("IsValid char = " + isValidChar +", isValidNumber = " + isValidNumber);
	}
	
	log ("Result of keypress = " + result);
	
	return result;
}

function onClickUserDefinedColourBlock ( groupName, selectedColourId ,  userDefinedId, userDefinedTextId)
{
	widget.openURL("http://www.htmlhelp.com/icon/hexchart.gif");
	onClickColourBlock ( groupName, selectedColourId,  userDefinedId, userDefinedTextId)
}


function getSelectedRadioOption ( radioGroupName , defaultValue)
{
	result = null;
	found = false;
	
	i = 0 ;
	radioGroup = document.getElementsByName (radioGroupName);
	
	while ( i < radioGroup.length && !found )
	{
		item = radioGroup.item(i);
		log ("item = " + item);
		log ("item = " + item.checked);
		found = item.checked;
		i++;
	}
	
	if (found)
	{
		result = item;
	}
	else
	{
		result = document.getElementById (defaultValue);	
	}
	
	return result;
}

function onClickDoneButton ( )
{
log("-----> getConfigFromControls");
	getConfigFromControls ();
log("-----> savePreferences");
	savePreferences();
log("-----> hidePrefs");
	hidePrefs();
log("-----> setControlsFromConfig");
	setControlsFromConfig();
log("-----> getNotePad focus");
	getNotePad().focus();        
}

function onClickNewButton ( ) 
{
	if ( canCreateNewEntry() )
	{
		clearStatusBar();
		log ("Creating new note..");
		getEntriesCombo().selectedIndex = 0;
		loadEntry ( KEY_NEW_ENTRY);	
		getNotePad().focus();  
	}
	else
	{
		log ("Too many notes..");
		writeToStatusBar ("There is a limit of " + maxEntries + " notes per Notepad instance.");
	}
}

function  onClickDeleteAllButton ( ) 
{
	removeAllEntries ();	
	populateEntriesCombo( true );
	getNotePad().value = "";
	refreshNumberOfEntries();
}



function onClickDeleteButton ( ) 
{
	clearStatusBar();
	deletePreferenceItem ( getSelectedOption ( getEntriesCombo() ).value );
	
//	removeComboItem ( getEntriesCombo(),getEntriesCombo().selectedIndex );
	populateEntriesCombo( true );
	getNotePad().value = "";
	getNotePad().focus();  
}

function onClickFlip( event )
{
	clearStatusBar();
	showPrefs ( event );
	document.getElementById ('idCategoryName').focus();        
	
	refreshNumberOfEntries();
}

function onClickSaveButton ( ) 
{
	clearStatusBar();
	saveEntry();
	getNotePad().focus();  
}



function onClickUrl ( url ) 
{
	widget.openURL( url );
}

function onBlurTextArea ( ) 
{	
	onBlurTextArea.blur;
	if ( isAutoSaveOn() )
	{
		value = getNotePad().value;

		log ( "notepad value = " + value);

		if ( value  )
		{
			if ( value.trim().length > 0 )
			{
				saveEntry ( );
			}
		}
	}
	
	log ("done onBlurTextArea");
}

function saveEntry ( )
{
	oldKey = getSelectedOption ( getEntriesCombo()).value;
	newKey = null;

	notepadText = getNotePad().value;

	log ("oldKey = " + oldKey + ", new entry = " + KEY_NEW_ENTRY + getNotePad().value);


	//create a new key if this is a new entry
	if ( oldKey == KEY_NEW_ENTRY )
	{
		newKey = createEntryKey(); 
		newKey = createkey (  KEY_NOTEPAD_ENTRY, newKey ) 

		log ("NewKey = " + newKey);
	}
	else
	{
		log ("Existing entry...");
		newKey  =  oldKey
	}
	log ( "new text = " +  notepadText );
	log ( "saving entry with key = " + key );
		
	saveNoteEntry (   newKey, oldKey, notepadText );
	
	title = getTitle();
	
	//if new entry then add this to combo
	if ( oldKey == KEY_NEW_ENTRY )
	{
		log ("Adding to combo with key = " + newKey);
		addToCombo ( getEntriesCombo(), newKey, title );
	}	
	else
	{	
		//the combo text will be updated with the new title
		index = getEntriesCombo().selectedIndex;
		log ( "index = " +  index )
		getEntriesCombo().options[ index ].text =  title;
	}
	
	log ("combo " + newKey);
	index = comboIndexOfByValue ( getEntriesCombo(), newKey);
	log ("index = " + index);
	
	getEntriesCombo().options.selectedIndex = index;
}		

/** Checks whether a new entry can be created
	At the moment, checks for less than 49 entries in the subject combo box
**/
function canCreateNewEntry (  )
{
	result = getEntriesCombo().options.length < maxEntries;
	return result;
}

function createkey ( key )
{
	log ("createkey, key = " + key);
	return getWidgetId() + "_" + key;
}

function removeAllEntries ( ) 
{
	log ("Removing all Entries ");

	for ( i = 0 ; i < getEntriesCombo().length ; i ++ )
	{
		key = getEntriesCombo().options [ i ].value;
		
		log ( "Removing entry with key = " + key );
		
		deletePreferenceItem ( key );
	}
}

function removeSettings ( ) 
{
	log ("Removing Settings");
	deletePreferenceItem ( createkey( KEY_MAX_ENTRIES ) ); 	
	deletePreferenceItem ( createkey( KEY_CATEGORY_NAME ) ); 	
	deletePreferenceItem ( createkey( KEY_AUTOSAVE ) ); 	
	deletePreferenceItem ( createkey( KEY_TEXT_COLOUR ) ); 	
	deletePreferenceItem ( createkey( KEY_USER_DEFINED_TEXT_COLOUR ) ); 	
	deletePreferenceItem ( createkey( KEY_USER_DEFINED_BACKGROUND_COLOUR ) ); 	
	deletePreferenceItem ( createkey( KEY_BACKGROUND_COLOUR ) ); 	
	deletePreferenceItem ( createkey( KEY_FONT_TYPE ) ); 		
	deletePreferenceItem ( createkey( KEY_CATEGORY_NAME ) ); 	
	deletePreferenceItem ( createkey( KEY_FONT_TYPE ) ); 	
}

function getWidgetId() 
{
	return widget.identifier;
//	return "widgetId";
}

function createEntryKey () 
{
	keyToReturn = null;
	
	i = 0 ;
	while ( i < getMaxEntries() && !keyToReturn )
	{
		key = createkey( KEY_NOTEPAD_ENTRY,i )
		value = widget.preferenceForKey(  key )  ; 
		
		log ( "creating - value = " + value);
		
		if ( !value )
		{
			log ( " value = " + value + ", key = " + key );
			keyToReturn = i;
		}
		
		i++;
	}	

log ("new key = " + keyToReturn );
	
	return keyToReturn;
}

/** Populate Entry combo.  

	params:
		is loadItems is true, the combo will be populated with any existing entrys
				        false, then only populate with defaults.  Optimization.. don't slow down 
				        the widget for unnecessary tasks
**/				   
function populateEntriesCombo ( loadItems )
{
	if ( loadItems  )
	{
		items = getComboItems ( );
	}
	
	
	if ( DEBUG_TEST )
	{	
		items = getComboItemsTest ( );
	}
	
	getEntriesCombo().length = 0;

	addToCombo ( getEntriesCombo(), KEY_NEW_ENTRY,"New Entry");

	if ( loadItems )
	{
		log("Adding Items");
		//add the items ( key, value object ) to the entry combo
		buildComboWithList ( getEntriesCombo() , items );
		
		log("Done loading items for combo");
	}

}

/** Creates a key. The subkey is optional **/
function createkey ( key , subkey)
{
	returnKey = null;

	if ( subkey )
	{
		returnKey = getWidgetId() + "_" + key + subkey;

	}
	else
	{
		 returnKey = getWidgetId() + "_" + key;
	}

	log ("key created = " + returnKey);
	 
	return returnKey;
}

function refreshNumberOfEntries () 
{
//	document.getElementById ('idNumOfEntries').innerHTML = getEntriesCombo().options.length -1;
}

/* Returns the index of an item ( Text ) for the combo

	params:
		Combo 	to search
		item 	text to search for
		
	If item cannot be found, NOT_FOUND is returned
*/
function comboIndexOfByValue ( combo , item )
{
	found = false;
	i = NOT_FOUND;
	
	log ("Searching for item = " + item );
	
	while ( i < combo.length && !found )
	{
		i++;
		key = combo.options [ i ].value;
		
		log ("current key = " + key);
		
		found  = key == item;
	}
	
	if (!found)
	{
		i =  NOT_FOUND;
	}

	log ("combo of index = " + i);
	
	return i;
}

function comboIndexOfById ( combo , item )
{
	found = false;
	i = NOT_FOUND;
	
	log ("Searching for item = " + item );
	
	while ( i < combo.length && !found )
	{
		i++;
		key = combo.options [ i ].id;
		
		log ("current id = " + key);
		
		found  = key == item;
	}
	
	if (!found)
	{
		i =  NOT_FOUND;
	}

	log ("combo of index = " + i);
	
	return i;
}

function getSelectedIndex ( combo )
{
	return combo.selectedIndex;
}

function getSelectedOption ( combo )
{
	log (" in selected option");
	log ("idnex = " + getSelectedIndex( combo ));
	log ( "getSelected option = " + combo.options [ combo.selectedIndex].value);
	return combo.options [ combo.selectedIndex];
}

/** Setup colour blocks with the relevent colours # hash **/
function setupColourBlock ( groupName )
{
	group = document.getElementsByName ( groupName );

	for ( i = 0 ; i < group.length ; i++)
	{
		item = group.item ( i );
		item.colourCode = colourCode [ i ];
		item.checked = false;
		log ("item = " + item.id + ", itemColourCocde = " + item.colourCode);
	}
}

function setup() 
{
	log("on setup ");
	if (window.widget)
	{
	    widget.onshow = onshow;
	    window.onfocus = focus;
	    window.onblur = blur;
	    widget.onremove = onRemoveWidget
		
	}
	
	
	
	
	loadPreferences();

	setupColourBlock ( 'textColourBlock');
	setupColourBlock ( 'backgroundColourBlock');
	
	
	
	setControlsFromConfig ( );
	populateEntriesCombo ( true );
	onshow();
	
	log("Creating  Buttons...");
	createGenericButton(document.getElementById("idNewButton"), "New", onClickNewButton, 60);
	createGenericButton(document.getElementById("idSaveButton"), "Save", onClickSaveButton, 60);
	createGenericButton(document.getElementById("idDeleteButton"), "Delete", onClickDeleteButton, 60);

	//text colour is white, so need to change it to black
	log("Changing button colour");
	changeTextColour ( "idNewButton",COLOUR_BLACK );
	changeTextColour ( "idSaveButton", COLOUR_BLACK );
	changeTextColour ( "idDeleteButton", COLOUR_BLACK );

	log("Creating additional buttons..");
	createGenericButton(document.getElementById("idDoneButton"), "Done", onClickDoneButton, 60);
	//createGenericButton(document.getElementById("idDeleteAllButton"), "Delete All", onClickDeleteAllButton, 60);
	
//	document.getElementById('idMaxEntries').disabled = true;
	
	log("Done Setup.");
}

//Changes the text colour of the Apple 'default colour'
function changeTextColour ( id , colour )
{
	button = document.getElementById( id );
	divChild =  button.childNodes[1];
	divChild.style.color=colour;
}

function setTextColour ( index )
{
	log ( "Colour index = " + index)

	textColour = index;
	log ( "Persist textColour = " + index);
}

function getEntriesCombo ( )
{
	return document.getElementById('idEntriesCombo');
}

function getNotePad ( )
{
	return document.getElementById('idNotePadText');
}

function getFontSizeCombo ( ) 
{
	return document.getElementById('idFontSize');
}

function getFontTypeCombo ( )
{
	return document.getElementById('idFontType');
}

function getBackgroundImageCombo ( ) 
{
	return document.getElementById ('idBackgroundImage');
}


function getComboItemsTest( ) 
{
	items = new Array;
	
	for (  i = 0 ; i < 10 ; i++ )
	{
		item = new Object();
		
		
		item.key = createkey( KEY_NOTEPAD_ENTRY, i );
		item.value = "Item " + i;
		
		items[i] =  item;
	}
	
	
	return items;
}

function getComboItems ( )
{
	list = new Array;
	index = 0;
	
	for ( i = 0 ; i < getMaxEntries() ; i++ )
	{
		key = createkey (  KEY_NOTEPAD_ENTRY, i ) 	
		value = widget.preferenceForKey(  key   );
		
		if  ( value )
		{
			item = new Object();
			
			item.key = key;
			item.value = value;
			
			list [ index ] = item;
			index++;
		}
	}
	
	
	return list;	
}


function buildComboWithList ( combo, items , defaultsOnly)
{
	for ( i = 0 ; i < items.length ; i++ )
	{
		item = items [ i ];
		
		log ("item = " + item);
		title = getTitle( item )
		addToCombo ( combo, item.key, title);
	}
}

function addToCombo ( combo, key, value )
{
	log("adding with " + key + ", value = " + value);
	option = new Option (  value, key );
	combo.add ( option );
}

function  setControlsFromConfig ( )
{
//	document.getElementById ("idMaxEntries").value =maxEntries;
	document.getElementById ("idCategoryDisplay").innerHTML =categoryName;
	document.getElementById ("idCategoryName").value =categoryName;
	document.getElementById ("idAutoSave").checked=autoSave;


	log ("Setting user defined background colour check");
//	document.getElementById (userDefinedBackgroundColour).checked = true;
	
	log ("setting colour controls");
	log ( " bg colour = " + backgroundColour);
	log ( " text colour = " + textColour);
	
	
	
	setColourControls ( "backgroundColourBlock", backgroundColour, userDefinedBackgroundColour, "userBackground","userDefinedBackground");
	
	log("*************************************************************");
	log ( " text colour = " + textColour);
	log (" user defined text = " + userDefinedTextColour);
	setColourControls ( "textColourBlock", textColour, userDefinedTextColour, "userText","userDefinedText");
	
	
	if (  userDefinedBackgroundColour )
	{	
		log("userDefinedBackgroundColour = " + userDefinedBackgroundColour);
		bgColour = userDefinedBackgroundColour;
		
	}
	else
	{
		log ( "document.getElementById(backgroundColour).colourCode = " + document.getElementById(backgroundColour));
		bgColour = document.getElementById(backgroundColour).colourCode;
	}
	
	if ( userDefinedTextColour ) 
	{
		log ("userDefinedTextColour = " + userDefinedTextColour);
		colorText = userDefinedTextColour;
	}	
	else
	{
		log ("document.getElementById(textColour).colourCode; = " + document.getElementById(textColour));
		
		if ( document.getElementById(textColour) )
		{
			colorText = document.getElementById(textColour).colourCode;
		}
		else
		{
			colorText = DEFAULT_BACKGROUND_COLOUR;
		}
	}
	
	log ( "fontType = " + fontType);
	log ("fontSize = " + fontSize);
	setComboValue ( getFontTypeCombo(), fontType, DEFAULT_FONT_TYPE);
	setComboValue ( getFontSizeCombo(), fontSize, DEFAULT_FONT_SIZE);
	
	log (" set controls done");
	getNotePad().style.fontFamily = fontType;
	getNotePad().style.fontSize = fontSize + "pt";
	
	log ("userDefinedBackgroundColour = " + bgColour);
	log ("userDefinedTextColour = " + colorText);
	
	getNotePad().style.backgroundColor =bgColour;
	getNotePad().style.color = colorText;
	
	setupBackgroundImageCombo ( backgroundImage );
	
	document.getElementById ('front').style.backgroundImage = "url("+backgroundImage+")";
	
}

function setupBackgroundImageCombo ( imageName )
{
	combo = document.getElementById( "idBackgroundImage");
	
	log ("Combo = " + combo);
	log ("imageName = " + imageName);
	log("combo length = " + combo.length);
	index = comboIndexOfById( combo, imageName );
	
	log ("index = " + index);
	
	if ( index == NOT_FOUND )
	{
		index = DEFAULT_BACKGROUND_IMAGE;
		index = comboIndexOfById ( combo, imageName);
	}
	
	combo.selectedIndex = index;
}

/** Populate colour controls - the colour boxes and user defined text box 

	params:
		radioGroupBox			-  radio box name
		selectedColourId		-  the selected colour box  ( its Id)
		backgroundColour 		-  background Colour text ( the id of the radio box )
		userDefinedColour 		-  the userDefinedColour ( normally #ccccccc ) for example - colour code
		userDefinedColourBlock  -  id of the user defined colour block ( the hash)
		userDefinedColourTextId - the ID of the user defined colour text input
**/
function setColourControls ( radioGroupBox, selectedColourId, backgroundColour, userDefinedColourBlock, userDefinedColourTextId )
{
	onClickColourBlock ( radioGroupBox, document.getElementById (selectedColourId ), userDefinedColourBlock, userDefinedColourTextId );
	
	log(" user defined = " + document.getElementById (selectedColourId ).id);
	document.getElementById ( userDefinedColourTextId ).value = backgroundColour;
}


function setComboValue ( combo, id, defaultValue )
{
	log ("set Combo Value");
	index = comboIndexOfByValue ( combo, id);

	
	if  ( index == NOT_FOUND )
	{
		index = defaultValue;
	}

	log ("Combo index = " + index);
	
	combo.selectedIndex = index;
}

function setupColourPicker ( radioGroupBox, selectedColourId, backgroundColour, userDefinedColourBlock, userDefinedColourTextId )
{
	onClickColourBlock(radioGroupBox, selectedColourId, userDefinedColourBlock,userDefinedColourTextId);

	log (" colour = " + colour);
//	log ( "colour =  " + colour +", " + colour.substring(0,1)) ;
	log ( "text id " + userDefinedTextId);
	strColour = new String ( colour );
	
	if ( strColour.substring(0,1) == "#" )
	{
		log ("settings custom text");
		log ("Colour = " + colour);
		document.getElementById (userDefinedTextId).value = colour;
	}
	
}

function getConfigFromControls ( )
{
	log ("getConfigFromControls");
//	maxEntries = document.getElementById ("idMaxEntries").value;
	categoryName = document.getElementById ("idCategoryName").value;
	autoSave = document.getElementById ("idAutoSave").checked;
	
	//textcolour, background colour variables are kept up to date
	backgroundColour = getSelectedRadioOption ( "backgroundColourBlock",DEFAULT_BACKGROUND_COLOUR).id;
	userDefinedBackgroundColour = document.getElementById("userDefinedBackground").value;

	textColour = getSelectedRadioOption ( "textColourBlock",DEFAULT_TEXT_COLOUR_INDEX).id;
	userDefinedTextColour = document.getElementById("userDefinedText").value;

	backgroundImage = getBackgroundImageCombo().options [ getBackgroundImageCombo().selectedIndex].id;
	
	log ( "backgroundImage = " + backgroundImage);
	
	fontType = getSelectedOption ( getFontTypeCombo() ).value;
	fontSize = getSelectedOption ( getFontSizeCombo() ).value; 
}

function getComponentColourId ( colourId, postFix) 
{
	name = "user";
	strColour = new String ( colourId); //if I don't do this, colourId won't work with substring - not a string

	if ( strColour.substring(0,1) != "#")
	{
		log("Colour is not userdefined");
		log ("Colour ID = " + strColour);
		name = colours [ colourId ];
	}
	
	name = name + postFix;
	
	return name;
}

function onshow()
{
	getNotePad().focus;
}

function getEntryKey ( ) 
{
	return createEntryKey ( );
}

/* Get title of the notepad entry - this is the first line.  Only the first 20 chars are taken, 
   otherwise will be too long for Entry combo
   params -
   notepadText 		If null then get the textd from the textarea
*/

function getTitle ( notepadText )
{
	var source;

	if ( notepadText )
	{
		log ( "getting source from entire entry");
		source = notepadText;
	}
	else
	{
		log ("Getting source from textarea");
		source = getNotePad();
	}

	title = getTextAtLine ( source,0 );
	title = title.substring ( 0, 20);
	
	log ("Title = " +  title);
	
	return title;
}

/** Returns the line number of the textarea **/
function getTextAtLine(textArea, lineNo) 
{
  var lines = textArea.value.split(/\r\n|\r|\n/);

  if (lineNo >= 0 && lines.length > lineNo)
    return lines[lineNo]
  else 
    return null;
}

function getMaxEntries ( )
{
	return maxEntries;
}

function isAutoSaveOn ( ) 
{
	isChecked = document.getElementById ("idAutoSave").checked;
	
	log("isAutoSaveOn, isChecked = " + isChecked);
	
	return isChecked;
}


function writeToStatusBar ( msg )
{
	log ("message is = " + msg);
	sb = document.getElementById ( "statusBar");
	sb.innerHTML = msg;
	sb.style.visibility = "visible";
}

function clearStatusBar ()
{
	sb = document.getElementById ( "statusBar");
	sb.innerHTML = "";
	sb.style.visibility = "hidden";
	
}

function focus ( )
{
}

function blur  ( )
{	
	clearStatusBar();
}

/** When the widget is removed from dashboard, remove all related prefs **/
function onRemoveWidget ( ) 
{
	log ("removing settings");
	removeSettings ( );
	log ("removing entries");
	removeAllEntries();
	log("All preferences for this widget deleted ");
}


String.prototype.trim = function() 
{

 // skip leading and trailing whitespace
 // and return everything in between
  var x=this;
  x=x.replace(/^\s*(.*)/, "$1");
  x=x.replace(/(.*?)\s*$/, "$1");
  return x;
}


/**** Below is Apple Javascript code *****/



function showPrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
        
    if (window.widget)
        widget.prepareForTransition("ToBack");
                
    front.style.display="none";
    back.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);  
}

function hidePrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("back");
        
    if (window.widget)
        widget.prepareForTransition("ToFront");
                
    back.style.display="none";
    front.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
}



var flipShown = false;

var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}


function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}


function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
                
        
    T = limit_3(time-animation.starttime, 0, animation.duration);
        
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
        
    animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}
function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function enterflip(event)
{
//	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
//	document.getElementById('fliprollie').style.display = 'none';
}


/**** stretcher stuff ******/

var stretcher;

function setupStretch () 
{
	stretcher = new Stretcher(document.getElementById('frontContent'), 300, 250, null);
}

/*
 * Stretcher constructor.  Parameters:
 *
 * -- element: The element to stretch
 * -- doneNotification: A callback (if no callback is needed, pass null)
 *
 */
function Stretcher (element, stretchDistance, stretchDuration, onFinished) {
	this.element = element;

	this.startTime = 0;
	this.timer = null;
	
	this.duration = stretchDuration;
	this.multiplier = 1;
	this.stretchTime = 0;
	
	this.stretchDistance = stretchDistance;
	
	// min and max position can be changed to alter the stretched/shrunk sizes;
	// getComputedStyle depends on the target (in this case, the stretcher element)
	// being visible, so don't instantiate the Stretcher until the content is shown
	this.minPosition = parseInt(document.defaultView.getComputedStyle(this.element, "").getPropertyValue("height"));
	this.maxPosition = this.minPosition + this.stretchDistance;
	
	// Set variables to what they'd be in the beginning "shrunk" state
	this.positionFrom = this.minPosition;
	this.positionNow = this.minPosition;
	this.positionTo = this.minPosition;
		
	this.onFinished = onFinished;
}

/*
 * This should only be called via a Stretcher instance, i.e. "instance.stretch(event)"
 * Calling Stretcher_stretch() directly will result in "this" evaluating to the window
 * object, and the function will fail; parameters:
 * 
 * -- event: the mouse click that starts everything off (from an onclick handler)
 *		We check for the shift key to do a slo-mo stretch
 */
Stretcher.prototype.stretch = function (event) {
	if (event && event != undefined && event.shiftKey) {
		// enable slo-mo
		this.multiplier = 10;
	} else this.multiplier = 1;
	
	var timeNow = (new Date).getTime();
	
	if (this.timer != null) {
		// We're already stretching in some direction;
		// change the destination position and restart the timer
		clearInterval(this.timer);
		this.timer = null;
		this.stretchTime -= (timeNow - this.startTime);
		this.positionFrom = this.positionNow;
	} else {
		this.stretchTime = this.duration * this.multiplier;
		this.positionFrom = this.positionNow;
	}

	// Change from our previous direction
	if (this.positionTo == this.minPosition) {
		this.positionTo = this.maxPosition;
	} else {
		this.positionTo = this.minPosition;
	}

	// If we're expanding, resize the window to make room for the newly-sized content
	// We don't want to do this before shrinking because we'll clip the content
	// Check for the widget object because this will be annoying in Safari
	if (window.widget && (this.positionTo == this.maxPosition)) {
		window.resizeTo(parseInt(document.defaultView.getComputedStyle(this.element, "").getPropertyValue("width")), this.positionTo);
	}

	this.startTime = timeNow - 13; // set it back one frame.
		
	// We need to store this in a local variable so the timer
	// does not lose scope when invoking tick
	var localThis = this;
	this.tick();
	this.timer = setInterval (function() { localThis.tick(); }, 13);

}
		
/*
 * Tick does all the incremental resize work
 * This function is very similar to the tick() function in the Fader sample
 */
Stretcher.prototype.tick = function () {
	var T;
	var ease;
	var time  = (new Date).getTime();
	var frame;
		
	T = limit_3(time-this.startTime, 0, this.stretchTime);
	ease = 0.5 - (0.5 * Math.cos(Math.PI * T / this.stretchTime));

	if (T >= this.stretchTime) {
		// go to the finished position when the timer is up
		this.positionNow = this.positionTo;
		clearInterval (this.timer);
		this.timer = null;
		// If we're shrinking, we resize the window AFTER the animation is complete
		// Otherwise we'll clip the content as it shrinks
		if (window.widget && this.positionTo == this.minPosition) {
			window.resizeTo(parseInt(document.defaultView.getComputedStyle(this.element, "").getPropertyValue("width")), this.positionNow);
		}
		if (this.onFinished) {
			// call after the last frame is drawn
			var localThis = this;
			setTimeout (function() { localThis.onFinished(); }, 0);
		}
	} else {
		this.positionNow = parseInt(computeNextFloat(this.positionFrom, this.positionTo, ease));
	}

	this.element.style.height = this.positionNow + "px";
}

/*
 * Report whether or not the Stretcher is in its maximized position
 * DO NOT call this function to determine whether or not the Stretcher is 
 * currently animating; set the onFinished handler to be notified when animation
 * is complete
 */
Stretcher.prototype.isStretched = function() {
	return (this.positionNow == this.maxPosition);
}


